import { Router } from 'express';
import { subscriptionsController } from './controller';
import { authenticateUser, requireAdmin } from '@/middlewares/auth';

const router = Router();

// --- Subscription Plans ---
router.get('/plans', subscriptionsController.getPlans); // public
router.post('/plans', authenticateUser, requireAdmin, subscriptionsController.createPlan); // admin
router.put('/plans/:id', authenticateUser, requireAdmin, subscriptionsController.updatePlan); // admin
router.delete('/plans/:id', authenticateUser, requireAdmin, subscriptionsController.deletePlan); // admin

// --- Vendor Subscriptions ---
router.get('/my-plan', authenticateUser, subscriptionsController.getMyPlan); // vendor
router.post('/activate', authenticateUser, subscriptionsController.activatePlan); // vendor
router.get('/trial-offer', authenticateUser, subscriptionsController.getTrialOffer); // vendor
router.post('/accept-trial', authenticateUser, subscriptionsController.acceptTrial); // vendor

// --- Features (admin) ---
router.get('/features', authenticateUser, requireAdmin, subscriptionsController.getAllFeatures); // admin
router.put('/features/:id', authenticateUser, requireAdmin, subscriptionsController.updateFeature); // admin
router.post('/features/assign', authenticateUser, requireAdmin, subscriptionsController.assignFeatureToPlan); // admin
router.post('/features/remove', authenticateUser, requireAdmin, subscriptionsController.removeFeatureFromPlan); // admin

// --- Trial Settings (admin) ---
router.put('/trial-settings', authenticateUser, requireAdmin, subscriptionsController.updateTrialSettings); // admin

// --- Feature Gate ---
router.get('/my-features', authenticateUser, subscriptionsController.getAvailableFeatures); // vendor

export default router; 